#ifdef GL_ES
attribute vec3 inVertex;
attribute vec2 inTexCoord0;

varying vec2 vTexCoord;
#else
in vec3 inVertex;
in vec2 inTexCoord0;

out vec2 vTexCoord;
#endif
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform vec2 textureOffset;

void main()
{
	vTexCoord = textureOffset + inTexCoord0;
	gl_Position = projectionMatrix * modelViewMatrix * vec4(inVertex, 1.0);
}
